-- Author: Habu
-- Date: Feb 2018
-- Title: DCSW 2.5 MOOSE script
-- Scenario: Repeated, random explosions in a zone
--           to simulate ground battle artillery.
-- Tested and works. To do: SchedulerStop() function when Player exits larger zone


Player1 = GROUP:FindByName( "Player" )  -- Initialize group to trigger explosions
      
ExplScheduler = SCHEDULER:New( nil, -- Explosion scheduler
  function()
    
    Intensity = math.random( 300, 700 )  -- Random intensity between 300 and 700 for explosion
    Expl_Zone = ZONE_GROUP:New( "Zone A", Player1, 2500 ) -- Instantiate a new trigger zone, 2500m radius.
    Explode = COORDINATE:NewFromVec2( Expl_Zone:GetRandomVec2() )  -- Sets random explosion location in zone
    Explode:Explosion( Intensity )  -- Random intensity.
    
  end, {}, 0, 4, .8  -- Explosions start after 0 sec, average every 4 sec. with time variation of .8 (0-1, 0= no variation)
  )
  
